package lokaleklasse3;

import java.util.ArrayList;
import java.util.List;

/**
 * Demonstriert eine Lokale Klasse und deren Zugriffsmoeglichkeiten.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.05.2007
 */
public class Person {
	private String name;
	
	public Person(String name) {
		this.name = name;
	}
	
	public List<String> getGewissenBisse() {
		
		class GewissensListe extends ArrayList<String> {
			
			public GewissensListe(String ... gewissenBisse) {
				for(String s: gewissenBisse) {
					add(s);
				}
			}
			
			public String toString() {
				StringBuilder sb = new StringBuilder();
				
				sb.append("Hallo ").append(name).append("\n");
				sb.append("Hier ist dein inneres Gewissen und ich frage dich:\n");
				for(String s: this) {
					sb.append(s).append("\n");
				}
				
				return sb.toString();
			}
		}
		
		return new GewissensListe("Ist der Herd aus?", "Ist der Hosenstall zu?");
	}
	
	public static void main(String[] args) {
		Person p = new Person("WilliWacker");
		List l = p.getGewissenBisse();
		System.out.println(l);
		
		System.out.println(l.getClass());
		// Das Objjekt lebt zwar weiter aber die Klasse an sich ist nicht mehr sichtbar.
		// Daher funktioniert folgender Cast nicht
		// GewissensListe gl = (GewissensListe)l;
	}
}
