package lokaleklasse1;

/**
 * Demonstriert eine Lokale Klasse und deren Zugriffsmoeglichkeiten.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 25.05.2007
 */
public class LokaleKlasse {

	final static String klassenVar1 = "final LokaleKlasse.Klassenvariable";

	static String klassenVar2 = "LokaleKlasse.Klassenvariable";

	public static void main(String[] args) {

		final String lokalVar1 = "final lokal Klassenvariable";
		String lokalVar2 = "lokal Klassenvariable";

		System.out.println("Programmstart");
		
		// MyLokal m = new MyLokal();  // klappt nicht, da die Klasse erst weiter unten deklariert wird
		
		class MyLokal {
			String s = "Instanzvariable";
			// static String k = "Test";  // Klassenvariablen nicht in Lokalen Klassen erlaubt
			final static String k = "final Instanzvariable";
			
			public String toString() {
				StringBuilder sb = new StringBuilder();

				sb
						.append("Die Lokale Klasse kommt an die folgenden Variablen:\n");
				sb.append(klassenVar1).append("\n");
				sb.append(klassenVar2).append("\n");

				sb.append(lokalVar1).append("\n");
				// sb.append(lokalVar2).append("\n"); // Klappt nicht, da nicht final
				
				sb.append(s).append("\n");
				sb.append(k).append("\n");
				return sb.toString();
			}
		}
		
		MyLokal m = new MyLokal();
		System.out.println(m);

	}

}
