package bounds1;

/**
 * Klasse Chef stammt von Person ab und implementiert das Interface Comparable.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.05.2007
 */
public class Chef extends Person implements Comparable<Chef> {
	private int anzAutos;
	
	/**
	 * Custom constructor.
	 * @param name Name des Chefs
	 * @param anzAutos Anzahl Autos
	 */
	public Chef(String name, int anzAutos) {
		super(name);
		this.anzAutos = anzAutos;
	}
	
	/**
	 * Erhoeht die Anzahl der Autos um 1-
	 */
	public void nochNAuto() {
		anzAutos++;
	}

	/**
	 * Vergleicht zwei Chef Objekte anhand der Anzahl der Autos
	 */
	public int compareTo(Chef o) {
		return anzAutos - o.anzAutos;
	}

	/**
	 * Stringrepraesentierung des Chefs
	 */
	public String toString() {
		return "ich heisse " + this.getName() + " und habe " + anzAutos + " Autos";
	}
}
