package bounds1;

/**
 * Eine typsichere Box in der ein Objekt enthalten sein kann. Das Objekt muss
 * Unterklasse von Person sein und zusaetzlich Comparable
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 25.05.2007
 * @param <E>
 */
public class Box<E extends Person & Comparable<E>> {
	E element;

	/**
	 * Element einstellen.
	 * @param element Einzustellendes Element
	 */
	public void put(E element) {
		this.element = element;
	}
	
	/**
	 * Element abholen
	 * @return In der Box enthaltenes Element
	 */
	public E get() {
		return element;
	}
	
	/**
	 * Stringrepraesentierung
	 */
	public String toString() {
		return element.toString();
	}
}
