package sleepingbarber;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

/**
 * Hauptprogramm. Verwendet eine anonyme Klasse, um einen TimerTask zu starten.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 14.05.2007
 */
public class RealWorld {

	public static void main(String[] args) {
		// Semaphore und Barber anlegen
		Semaphore plaetze = new Semaphore(5);
		Semaphore barberAvailable = new Semaphore(1);
		SleepingBarber b1 = new SleepingBarber("Barber");
		b1.start();

		final int CUSTOMERS = 10;
		
		// Kunden anlegen und starten
		final Customer[] customers = new Customer[CUSTOMERS];
		for(int i = 0; i<customers.length;i++) {
			customers[i] = new Customer(plaetze, barberAvailable, b1, "Kunde"+i);
			customers[i].start();
		}

		// InfoThread starten
		new Timer().schedule(new TimerTask() {
			public void run() {
				StringBuilder sb = new StringBuilder();
				for(Customer c: customers) {
					sb.append(c).append("\t");
				}
				System.out.println(sb);
			}
		},2000,2000);
	}

}