package producerconsumer1;

import java.util.concurrent.LinkedBlockingQueue;

/**
 * Ein Depot fuer eine beschraenkte Anzahl von Objekten.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 06.05.2007
 */
public class Depot {
	private LinkedBlockingQueue<Object> buffer;

	public Depot() {
		buffer = new LinkedBlockingQueue<Object>(5);
	}

	/**
	 * Ein Element ins Depot packen. Eventuell muss man warten bis das Depot
	 * wieder Platz hat. Die Methode ist auf das Depot synchronisiert, damit
	 * nicht gleichzeitig mehrere Aenderungen vornehmen koennen.
	 * 
	 * @param data
	 *            Einzustellendes Element.
	 */
	public void put(Object data) {
		try {
			System.out.printf(
					"%s hat das Element %s produziert und abgeliefert.%n", Thread
							.currentThread().getName(), data);
			buffer.put(data);
		} catch (InterruptedException e) {
			System.err.println("Wurde faelschlicherweise unterbrochen");
		}
		
	}

	/**
	 * Element vom Depot holen. Eventuell muss man warten, bis das Depot etwas
	 * enthaelt. Die Methode ist auf das Depot synchronisiert, damit nicht
	 * gleichzeitig mehrere Aenderungen vornehmen koennen.
	 * 
	 * @return Element aus dem Depot
	 */
	public Object get() {
		Object o = null;
		try {
			o = buffer.take();
		} catch (InterruptedException e) {
			System.err.println("Wurde faelschlicherweise unterbrochen");
		}
			System.out.printf("%s hat das Element %s abgeholt.%n", Thread
					.currentThread().getName(), o);

		return o;
	}

	/**
	 * Depot leer?
	 * 
	 * @return true wenn leer, sonst false
	 */
	public boolean empty() {
		return buffer.isEmpty();
	}
}
