package nestedtoplevel3;

/**
 * Eine simple Lsitenimplementation. Es werden MyListEntry Objekte verkettet.
 * MyListEntry ist eine nested top-level class.
 * 
 * @author Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet
 *         Osnabrueck
 * @date 21.05.2007
 */
public class MyList {

	private MyListEntry element;
	
	private static class MyListEntry {

		private Object value;
		private MyListEntry next;
		private MyListEntry previous;
		
		MyListEntry() {
			value = next = previous = null;
		}
		
		MyListEntry(Object value) {
			next = previous = null;
			this.value = value;
		}
		
		MyListEntry(MyListEntry previous, Object value, MyListEntry next) {
			this.previous = previous;
			this.value = value;
			this.next = next;
		}
	}

	public MyList() {
		element = null;
	}

	public void add(Object o) {
		if (element == null) {
			element = new MyListEntry(o);
		} else if(element.previous==null) {
			element.previous = new MyListEntry(null,o,element);	// Wird automatisch verkettet
			element = element.previous; // Neues Element wird zum aktuellen
			
		} else {
			MyListEntry newElement = new MyListEntry(element.previous,o,element);
			element.previous.next = newElement;
			element.previous = newElement;
			element = element.previous; // Neues Element wird zum aktuellen
		}
	}
	
	public String toString() {
		
		if(element == null) 
			return "[]";
		
		MyListEntry tmp = element;
		while(tmp.previous!=null) {
			tmp = tmp.previous;
		}
		
		StringBuilder sb = new StringBuilder("[");
		
		while(tmp.next!=null) {
			sb.append(tmp.value).append(",");
			tmp = tmp.next;
		}
		sb.append(tmp.value);
		sb.append("]");
		
		return sb.toString();
	}
}
