package nestedtoplevel2;

/**
 * Beispiel einer nested top-level class.
 * 
 * @author  Ralf Kunze (rkunze@uos.de), Institut fuer Informatik, Universitaet Osnabrueck
 * @date 21.05.2007
 */
public class Aussen {
	private String wert1;
	static String art = "Aeussere Klasse";
	private String name;
	
	private Innen innen;
	
	static private class Innen {
		private String wert2;
		
		public Innen(String wert2) {
			this.wert2 = wert2;
		}
		
		public String toString() {
			StringBuilder sb = new StringBuilder();
			
			sb.append("Mein Wert lautet: ").append(wert2);
			sb.append(" ich befinde mich innerhalb von ").append(art);
			// sb.append(" des Modells").append(name); // Zugriff auf name nicht erlaubt, da nicht statisch!
			return sb.toString();
		}
	}
	
	public Aussen(String wert1, String name) {
		this.name = name;
		this.wert1 = wert1;
		innen = new Innen("Innen-Objekt von der Klasse Aussen erzeugt");
	}
	
	public String toString() {
		StringBuilder sb = new StringBuilder();
		
		sb.append("Mein Wert lautet: ").append(wert1).append("\n");
		sb.append("Mein Name lautet").append(name).append("\n");
		sb.append("Die Infos vom Objekt meiner inneren Klasse:");
		sb.append(innen.wert2); // ACHTUNG! Sowohl die Klasse ist private, als auch das Datenfeld der inneren Klasse!!!
		return sb.toString();
	}
}
